'use strict'

entityRegistry['module']['fade'] = {
    extendedInfo: {
        displayName: 'Fade',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'fade', displayName: 'Fade', type: 'float', defaultValue: .9, uiOptions: { min: 0, max: 1, scrollScales: [0.01, 0.05, 0.1] }},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                fade,
            } = { ...config }

            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data
            const colorBuffer = renderer.getCurrentBuffer('color')
            const colorBufferData = colorBuffer.data
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const depthBufferData = depthBuffer.data
            const width = depthBuffer.width
            const height = depthBuffer.height

            const backgroundColor = 0

            const actualFade = Math.min(1, Math.max(0, fade))

            for (let x = 0; x < width; ++x) {
                let index = x
                let brightness = 0
                let color = 0
                let depth = 0
                for (let y = 0; y < height; ++y) {
                    const currentColor = colorBufferData[index]
                    const currentDepth = depthBufferData[index]
                    if (color !== backgroundColor) {
                        if (currentDepth < depth) {
                            brightness = brightnessBufferData[index]
                            color = currentColor
                            depth = currentDepth
                        }
                    } else if (currentColor !== backgroundColor) {
                        brightness = brightnessBufferData[index]
                        color = currentColor
                        depth = currentDepth
                    }
                    if (currentColor !== color) {
                        brightnessBufferData[index] = brightness
                        colorBufferData[index] = color + 1
                        depthBufferData[index] = depth
                        brightness *= actualFade
                        if (brightness < .001) {
                            color = backgroundColor
                        }
                    }
                    index += width
                }
            }
        }
    }
}
